<?php
$dataFile = 'banks.json';
$banks = file_exists($dataFile) ? json_decode(file_get_contents($dataFile), true) : [];

$logoPath = "";
if (isset($_POST['id']) && $_POST['id'] !== "" && isset($banks[$_POST['id']])) {
    $logoPath = $banks[$_POST['id']]['logo']; // задржи старо лого ако не се качи ново
}

// Ако е качено ново лого
if (!empty($_FILES['logo']['name'])) {
    $uploadDir = 'uploads/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }
    $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
    $fileName = uniqid('logo_') . "." . strtolower($ext);
    $targetPath = $uploadDir . $fileName;

    if (move_uploaded_file($_FILES['logo']['tmp_name'], $targetPath)) {
        $logoPath = $targetPath;
    }
}

$newData = [
    "logo" => $logoPath,
    "bank" => $_POST['bank'],
    "fee" => (float)$_POST['fee'],
    "periods" => []
];

foreach ($_POST['months'] as $i => $m) {
    if ($m !== "" && $_POST['rate'][$i] !== "") {
        $newData['periods'][] = [
            "months" => $m,
            "rate" => (float)$_POST['rate'][$i]
        ];
    }
}

if ($_POST['id'] !== "") {
    $banks[$_POST['id']] = $newData;
} else {
    $banks[] = $newData;
}

file_put_contents($dataFile, json_encode($banks, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
header("Location: index.php");
