<?php
$dataFile = 'banks.json';
$banks = file_exists($dataFile) ? json_decode(file_get_contents($dataFile), true) : [];
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Листа на банки</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
<h1>Листа на банки</h1>
<a href="form.php"><button>+ Додади нова банка</button></a>
<table>
    <tr>
        <th>Лого</th>
        <th>Име</th>
        <th>Fee</th>
        <th>Акции</th>
    </tr>
    <?php foreach ($banks as $index => $bank): ?>
    <tr>
        <td><img src="<?php echo htmlspecialchars($bank['logo']); ?>" alt="Logo" width="50"></td>
        <td><?php echo htmlspecialchars($bank['bank']); ?></td>
        <td><?php echo htmlspecialchars($bank['fee']); ?></td>
        <td>
            <a href="form.php?id=<?php echo $index; ?>"><button class="edit">Edit</button></a>
            <a href="delete.php?id=<?php echo $index; ?>" onclick="return confirm('Сигурно?')"><button class="delete">Delete</button></a>
        </td>
    </tr>
    <?php endforeach; ?>
</table>
</div>
</body>
</html>
