<?php
$dataFile = 'banks.json';
$banks = file_exists($dataFile) ? json_decode(file_get_contents($dataFile), true) : [];
$editData = ["logo" => "", "bank" => "", "fee" => "", "periods" => []];

if (isset($_GET['id']) && isset($banks[$_GET['id']])) {
    $editData = $banks[$_GET['id']];
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Форма банка</title>
    <link rel="stylesheet" href="style.css">
    <script>
    function addPeriod(months = "", rate = "") {
        let container = document.getElementById('periods');
        let div = document.createElement('div');
        div.className = 'period';
        div.innerHTML = `
            <input type="number" step="1" name="months[]" placeholder="Месеци" value="${months}">
            <input type="number" step="0.01" name="rate[]" placeholder="Процент" value="${rate}">
            <button type="button" onclick="this.parentNode.remove()">X</button>
        `;
        container.appendChild(div);
    }
    </script>
</head>
<body>
<div class="container">
<h1><?php echo isset($_GET['id']) ? "Уреди банка" : "Додади банка"; ?></h1>
<form action="save.php" method="post" enctype="multipart/form-data">
    <input type="hidden" name="id" value="<?php echo $_GET['id'] ?? ''; ?>">

    <?php if (!empty($editData['logo'])): ?>
        <p>Моментално лого:<br>
        <img src="<?php echo htmlspecialchars($editData['logo']); ?>" alt="Logo" width="80"></p>
    <?php endif; ?>

    <label>Лого (слика):</label>
    <input type="file" name="logo">

    <label>Име на банка:</label>
    <input type="text" name="bank" value="<?php echo htmlspecialchars($editData['bank']); ?>" required>

    <label>Fee:</label>
    <input type="number" step="0.01" name="fee" value="<?php echo htmlspecialchars($editData['fee']); ?>" required>

    <label>Периоди:</label>
    <div id="periods"></div>
    <button type="button" onclick="addPeriod()">+ Додај период</button>

    <br><br>
    <input type="submit" value="Зачувај">
</form>
</div>

<script>
<?php
if (!empty($editData['periods'])) {
    foreach ($editData['periods'] as $p) {
        echo "addPeriod('{$p['months']}', '{$p['rate']}');";
    }
}
?>
</script>
</body>
</html>
